<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:variable name="exportType">HTML</xsl:variable>
  <xsl:key name="product" match="/items/item/products/product/text()" use="." />
  
  <xsl:template match="report">
    	<html><head><style>
		body{font-family: "Segoe UI", "Arial",sans-serif;}
		body {padding:15px;}
		body, table, td, th{font-size:9pt; color:#555555}
		tr.header th{color:#ffffff; background-color:#555555}
		tr.header th.projectName{background-color:#cb5252}
		table{border-right:1px solid #cccccc; width:100%}
		th {padding:5px}
		th.subheader{border-top:2px solid #555555; border-bottom:1px solid #cccccc; background-color:#f2f8fd}
		td {border-bottom:1px solid #cccccc; border-left:1px solid #cccccc; padding:5px}
		td.total, th.total{background-color:#bdf4bb}
		</style>
		</head>
		<body>
		<table cellspacing="0" cellpadding="0">
			<tr class="header">
				<th>Date</th>
				<th>User</th>
				<th>Activity</th>
				<th>Start Time</th>
				<th>End Time</th>
				<th>Duration</th>
				<th>Comments</th>
			</tr>
		
			<xsl:for-each select="entries/entry">
				<xsl:variable name="resourceId" select="resource_id"/>
				<xsl:variable name="projectId" select="project_id"/>
				<tr>
					<td><xsl:value-of select="date"/></td>
					<td><xsl:value-of select="../../people/person[resource_id = $resourceId]/name"/></td>
					<td>
					<!--<xsl:value-of select="../../projects/project[project_id = $projectId]/name"/>-->
						<xsl:apply-templates select="../../projects/project[project_id = $projectId]/path"/>
					</td>
					<td><xsl:value-of select="start_time_stamp_formatted"/></td>
					<td><xsl:value-of select="end_time_stamp_formatted"/></td>
					<td>
						<!--
							<xsl:value-of select="duration"/>
						-->
					    <xsl:call-template name="minutesToHours">
							<xsl:with-param name="minutes" select="duration div 60000"/> 
						</xsl:call-template></td>
					<td><xsl:value-of select="comments"/></td>
				</tr>
			</xsl:for-each>	
		</table>
		
		
		</body>
		</html>
		
		
	</xsl:template>
	
	<xsl:template match="text()" name="toExtendedName">
		<xsl:param name="pText" select="."/>
		
		<xsl:if test="string-length($pText)">
			
			<xsl:if test="not($pText=.)">
				/
			</xsl:if>
			<xsl:variable name="theId" select="substring-before(concat($pText, '.'), '.')"/>
			
			<xsl:value-of select="/report/projects/project[project_id=$theId]/name"/>
			<xsl:call-template name="toExtendedName">
				<xsl:with-param name="pText" select="substring-after($pText, '.')"/>
			</xsl:call-template>
		</xsl:if>
		
	</xsl:template>
	
	<xsl:template name="minutesToHours">
		<xsl:param name="minutes"/>
		<xsl:value-of select="floor($minutes div 60)"/>:<xsl:if test="$minutes mod 60 &lt; 10">0</xsl:if><xsl:value-of select="$minutes mod 60"/>
	
  </xsl:template>
  
  
</xsl:stylesheet>	